USE [NWIC_PanelMgmt]
GO

/****** Object:  StoredProcedure [PanelMgmt].[usp_PMUpdateMasterLabIndexFromLOINC]    Script Date: 12/28/2015 1:55:27 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO



--=============================================================================================================
--Requestor				: Jianji Yang
--Author                : Steve Schreiner
--Object/SP Name		: [PanelMgmt].[usp_PMUpdateMasterLabIndexfromLOINC]
--SERVER				: DNS.URL        
--Data Base				: NWIC_PanelMgmt
--Schema				:    
--Report				: None Yet
--Folder				:
--Report Loc            : 
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 08-04-2014
--Last Changed          :   
--Last Changed By		: 
--Reason For Change		:                              
--Purpose               : Update Panel Management Master Lab Index table 
-----					  with lab test with valid LOINC codes.
--===============================================================================================================

CREATE PROCEDURE [PanelMgmt].[usp_PMUpdateMasterLabIndexFromLOINC_Original] 
AS

set		nocount on

select	ROW_NUMBER() OVER(
		ORDER BY lc.TestGroup) as RecID,
		cast(li.LOINCSID as varchar(50)) as LOINCSID,
		li.Sta3n,
		lc.LOINC,
		lc.TestGroup,
		lc.ResultForTestNumeric,
		cast(cast(dateadd(yy,lc.YearSearchCriteria,getdate()) as date) as varchar(50)) as YearSearchDate
into	#TempLOINCSID
from	[PanelMgmt].[PMMasterCohortLabTestGroupsLOINCCodes] as lc
inner join [CDWWork].[dim].[LOINC] as li on
		lc.LOINC = li.LOINC
inner join [PanelMgmt].[PMMasterCohortSite] as cs on
		li.Sta3n = cs.Sta3n;

declare @BegRec int, @EndRec int

select	@EndRec = max(RecID)
from	#TempLOINCSID as ls;

declare @NextRec int
set		@NextRec = 1

while	(@NextRec <= @EndRec)
begin

declare @exestr varchar(5000);

declare @LOINCSID varchar(50),
		@ResultForTestNumeric varchar(4),
		@TestGroup varchar(30),
		@LOINC varchar(50),
		@YearSearchDate varchar(50);

select	@LOINCSID = ''''+ls.LOINCSID+'''',
		@LOINC = ''''+ls.LOINC+'''',
		@ResultForTestNumeric = ls.ResultForTestNumeric,
		@TestGroup = ''''+ls.TestGroup+'''',
		@YearSearchDate = ''''+ls.YearSearchDate+''''
from	#TempLOINCSID as ls
where	ls.RecID = @NextRec;

set @exestr ='
insert			[PanelMgmt].[PMMasterLabIndex]
select			distinct
				li.LabChemTestSID,
				li.Sta3n,
				li.LabChemTestName,
				'+@ResultForTestNumeric+' as ResultForTestNumeric,
				getdate() as DateExtracted,
				'+@TestGroup+' as TestGroup,
				'+@LOINC+'as LOINC,
				NULL as WorkloadCode
from			[CDWWork].[Chem].[LabChem] lc
inner join		[CDWWork].[dim].[LabChemTest] as li on
				lc.LabChemTestSID = li.LabChemTestSID
where			lc.LOINCSID = '+@LOINCSID+'
				and lc.LabChemSpecimenDateTime > '+@YearSearchDate+'
				and not exists (select ni.LabChemTestSID
				                from [PanelMgmt].[PMMasterLabIndex] as ni
								where li.LabChemTestSID = ni.LabChemTestSID
								      and li.Sta3n = ni.Sta3n)'

exec (@exestr)

set		@NextRec = @NextRec + 1

end;

drop table #TempLOINCSID;

update	[PanelMgmt].[PMMasterCohortLabTestGroupsLOINCCodes]
set		LastUpdate = cast(getdate() as date);






GO


